package com.caohuayu.infobox;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;

import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity
implements View.OnClickListener, SearchView.OnQueryTextListener,
        AdapterView.OnItemClickListener{

    SearchView searchView = null;
    Button btnAdd = null;
    ListView listView=null;
    //
    List<String> dataId = new ArrayList<>();
    List<String> dataInfo = new ArrayList<>();
    private ArrayAdapter<String> adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        // 初始化数据库
        SQLiteDatabase db = openOrCreateDatabase(
                "infobox.db",MODE_PRIVATE,null);
        String sql = "create table if not exists "+
                "infobox(recid integer not null primary key,info text);";
        db.execSQL(sql);
        db.close();
        // 初始化控件
        searchView = (SearchView)findViewById(R.id.searchView);
        btnAdd = (Button)findViewById(R.id.btnAdd);
        listView = (ListView)findViewById(R.id.listView);
        //
        btnAdd.setOnClickListener(this);
        listView.setOnItemClickListener(this);
        //
        searchView.setSubmitButtonEnabled(true);
        searchView.setIconified(false);
        searchView.setOnQueryTextListener(this);
        // 绑定数据
        adapter = new ArrayAdapter<>(
                this,
                android.R.layout.simple_list_item_1,
                dataInfo);
        listView.setAdapter(adapter);
    }

    @Override
    protected void onStart() {
        super.onStart();
        //
        search(searchView.getQuery().toString());
    }

    /* 添加按钮 */
    @Override
    public void onClick(View v){
        // 显示
        Intent intent = new Intent(MainActivity.this,EditActivity.class);
        intent.putExtra("rowid","0");
        startActivity(intent);
    }

    /* 搜索 */
    @Override
    public boolean onQueryTextSubmit(String query){
        search(query);
        return false;
    }

    @Override
    public boolean onQueryTextChange(String newText){
        search(newText);
        return false;
    }

    // 根据关键字搜索内容
    protected void search(String key){
        dataId.clear();
        dataInfo.clear();
        //
        SQLiteDatabase db = openOrCreateDatabase(
                "infobox.db",MODE_PRIVATE,null);
        String sql = "select rowid,substr(info,1,15) as info "+
                "from infobox where info like '%"+key+
                "%' order by rowid desc limit 100;";
        Cursor cur = db.rawQuery(sql,null);
        if(cur.getCount()>0){
            while(cur.moveToNext()){
                dataId.add(cur.getString(0));
                dataInfo.add(cur.getString(1)+"...");
            }
        }
        else{
            Toast.makeText(MainActivity.this,
                    "没有找到相关的信息",Toast.LENGTH_SHORT).show();
        }
        cur.close();
        db.close();
        //
        adapter.notifyDataSetChanged();
    }

    /* 响应列表 */
    @Override
    public void onItemClick(AdapterView<?> parent,View view,int position,long id){
        Intent intent = new Intent(MainActivity.this,EditActivity.class);
        intent.putExtra("rowid",dataId.get((int)id));
        startActivity(intent);
    }
}