package com.caohuayu.audioplayer;

import androidx.appcompat.app.AppCompatActivity;

import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;

public class MainActivity extends AppCompatActivity
implements View.OnClickListener, AdapterView.OnItemClickListener,
        MediaPlayer.OnCompletionListener{

    // 控件对象
    private Button btnSingle;
    private Button btnRandom;
    private Button btnRepeat;
    private Button btnPlay;
    private ListView lst1;
    private TextView txtMsg;
    // 完整的文件名数组
    private String[] filenames;
    // 播放列表显示名称，只显示文件基本名称
    private String[] shownames;
    // 播放组件
    private MediaPlayer player = new MediaPlayer();
    // 当前播放索引值
    private int currentIndex=-1;
    // 循环方法，1单曲，2随机，3全部循环
    private int repeatState=3;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        // 对象初始化
        btnSingle=(Button)findViewById(R.id.btnSingle);
        btnRandom=(Button)findViewById(R.id.btnRandom);
        btnRepeat=(Button)findViewById(R.id.btnRepeat);
        btnPlay=(Button)findViewById(R.id.btnPlay);
        lst1=(ListView)findViewById(R.id.lst1);
        txtMsg=(TextView)findViewById(R.id.txtMsg);
        txtMsg.setText(R.string.stop);
        // 设置事件侦听
        btnSingle.setOnClickListener(this);
        btnRandom.setOnClickListener(this);
        btnRepeat.setOnClickListener(this);
        btnPlay.setOnClickListener(this);
        lst1.setOnItemClickListener(this);
        player.setOnCompletionListener(this);
        // 循环状态按钮颜色
        setButtonColor(btnSingle,false);
        setButtonColor(btnRandom,false);
        setButtonColor(btnRepeat,true);
        // 载入播放列表
        loadPlayList();
    }

    @Override
    protected void onDestroy(){
        player.stop();
        player.release();
        player=null;
        filenames=null;
        shownames=null;
        super.onDestroy();
    }

    // 设置按钮状态
    private void setButtonColor(Button btn,boolean isCur){
        if(isCur){
            btn.setBackgroundColor(getColor(R.color.purple_500));
            btn.setTextColor(getColor(R.color.white));
        }else{
            btn.setBackgroundColor(getColor(R.color.white));
            btn.setTextColor(getColor(R.color.black));
        }
    }


    // 按钮操作响应
    @Override
    public void onClick(View v) {
        int vid = v.getId();
        if(vid==R.id.btnPlay){
            if(filenames==null || filenames.length==0){
                loadPlayList();
            }else{
                if(player.isPlaying()){
                    player.pause();
                    btnPlay.setText(R.string.play);
                    txtMsg.setText(R.string.stop);
                }else{
                    player.start();
                    btnPlay.setText(R.string.stop);
                    txtMsg.setText("Playing : "+shownames[currentIndex]);
                }
            }
        }else if(vid==R.id.btnSingle){
            repeatState = 1;
            setButtonColor(btnSingle,true);
            setButtonColor(btnRandom,false);
            setButtonColor(btnRepeat,false);
        }else if(vid==R.id.btnRandom){
            repeatState = 2;
            setButtonColor(btnSingle,false);
            setButtonColor(btnRandom,true);
            setButtonColor(btnRepeat,false);
        }else if(vid==R.id.btnRepeat){
            repeatState = 3;
            setButtonColor(btnSingle,false);
            setButtonColor(btnRandom,false);
            setButtonColor(btnRepeat,true);
        }
    }

    // 列表项点击响应
    @Override
    public void onItemClick(AdapterView<?> parent,
                            View view, int position, long id) {
        play((int)id);
    }

    // 播放器状态
    @Override
    public void onCompletion(MediaPlayer mp){
        if(repeatState==1){
            // 单曲
            play(currentIndex);
        }else if(repeatState==2){
            // 随机
            play(new Random().nextInt(shownames.length));
        }else{
            // 循环
            int index = currentIndex+1;
            if(index>=shownames.length) index=0;
            play(index);
        }
    }

    // 载入列表
    private void loadPlayList(){
        File dir = new File(getExternalFilesDir(null),"");
        //
        File[] files = dir.listFiles();
        if(files==null){
            Toast.makeText(MainActivity.this,
                    "请在Android\\data\\com.caohuayu.audioplayer\\files文件夹准备.mp3文件",
                    Toast.LENGTH_LONG).show();
            return;
        }
        ArrayList<File>fileList = new ArrayList<File>();
        for(File f:files){
            if(f.getName().toLowerCase().endsWith(".mp3"))
                fileList.add(f);
        }
        //生成播放列表和显示列表
        int size = fileList.size();
        if(size>0){
            filenames=new String[size];
            shownames=new String[size];
            for(int i=0;i<size;i++){
                filenames[i] = fileList.get(i).getPath();
                String s = fileList.get(i).getName();
                shownames[i] = s.substring(0,s.length()-4);
            }
            // 绑定列表
            ArrayAdapter<String> ada=new ArrayAdapter<String>(
                    MainActivity.this,android.R.layout.simple_list_item_1,shownames);
            lst1.setAdapter(ada);
            // 准备播放器
            try {
                currentIndex = 0;
                //

                //
                player.setDataSource(filenames[currentIndex]);
                player.prepare();
                Toast.makeText(MainActivity.this,"音乐已准备",Toast.LENGTH_LONG).show();
            }catch (Exception ex){
                ex.printStackTrace();
            }
        }else{
            shownames=null;
            player.release();;
            Toast.makeText(MainActivity.this,
                    "请在Android\\data\\com.caohuayu.audioplayer\\files文件夹准备.mp3文件",
                    Toast.LENGTH_LONG).show();
        }
    }

    // 播放指定索引
    private void play(int index) {
        try{
            currentIndex = index;
            player.reset();
            player.setDataSource(filenames[currentIndex]);
            player.prepare();
            player.start();
            // 选中播放项
            btnPlay.setText(R.string.stop);
            txtMsg.setText("Playing : "+shownames[currentIndex]);
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }
}